unit woprchartable;

{ *************************************************************************** }
{ Copyright (c) 2008 Theo Lustenberger                                        }
{                                                                             }
{ This software is provided "as-is".  This software comes without warranty    }
{ or garantee, explicit or implied.  Use this software at your own risk.      }
{ The author will not be liable for any damage to equipment, data, or         }
{ information that may result while using this software.                      }
{                                                                             }
{ By using this software, you agree to the conditions stated above.           }
{ *************************************************************************** }

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, Grids, StdCtrls, LCLProc, unicodeinfo;

type

  { TFrmCharTable }

  TCharSelectedEvent = procedure(Sender: TObject; UTF8Char:String) of object;

  TFrmCharTable = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    procedure ComboBox1Select(Sender: TObject);
    procedure ComboBox2Select(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StringGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1SelectCell(Sender: TObject; aCol, aRow: Integer;
      var CanSelect: Boolean);
  private
    fOnCharSelected:TCharSelectedEvent;
    fCanSelect:Boolean;
    procedure InfoOut(S:Cardinal);

    { private declarations }
  public
    { public declarations }
    property OnCharSelected:TCharSelectedEvent read fOnCharSelected write fOnCharSelected;
  end; 

var
  FrmCharTable: TFrmCharTable;

implementation

{ TFrmCharTable }

procedure TFrmCharTable.FormShow(Sender: TObject);
var i, P:integer;
begin
 for i:=0 to MaxUnicodeRanges do
 Combobox1.Items.Add(UnicodeRanges[i].PG);
 Combobox1.ItemIndex:=0;
 Combobox1Select(nil);
 Combobox2.Text:='Font';
 {$ifdef LCLGtk2}
  for i:=0 to Screen.Fonts.Count -1 do
      begin
       P:=Pos('[',Screen.Fonts[i]);
       if P>0 then Combobox2.Items.Add(Trim(Copy(Screen.Fonts[i],1,p-1))) else Combobox2.Items.Add(Screen.Fonts[i]);
     end;

 {$else}
 Combobox2.Items.assign(Screen.Fonts);
 {$endif}
 Combobox2.ItemIndex:=Combobox2.Items.IndexOf(StringGrid1.Font.Name);
end;

procedure TFrmCharTable.StringGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  fCanSelect:=true;
end;

procedure TFrmCharTable.StringGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var S:Cardinal;
var ACol,ARow:integer;
begin
  StringGrid1.MouseToCell(X,Y,ACol,ARow);
  if (ACol>-1) and (ARow>-1) then
  begin
  S:=UnicodeRanges[Combobox1.ItemIndex].S+(ACol)+(ARow*16);
  InfoOut(S);
  end;
end;

procedure TFrmCharTable.StringGrid1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   fCanSelect:=false;
end;

procedure TFrmCharTable.StringGrid1SelectCell(Sender: TObject; aCol, aRow: Integer;
  var CanSelect: Boolean);
var S:Cardinal;
begin
if Combobox1.ItemIndex>-1 then
begin
 S:=UnicodeRanges[Combobox1.ItemIndex].S+(ACol)+(ARow*16);
 InfoOut(S);
 if fCanSelect then
 if Assigned(fOnCharSelected) then OnCharSelected(self,UnicodeToUTF8(S));
 fCanSelect:=false;
end;
end;

procedure TFrmCharTable.InfoOut(S: Cardinal);
var pr:putf8proc_property_t;
tmp,tmp2:String;
i:integer;
begin
 pr:=utf8proc_get_property(S);
 if pr<>nil then Label1.Caption:=utf8proc_getinfostring(pr);
 tmp:=UnicodeToUTF8(S);
 tmp2:='';
 for i:=1 to Length(tmp) do tmp2:=tmp2+IntToHex(Ord(tmp[i]),2);
 Label2.Caption:='U+'+inttohex(S,4)+LineEnding+'UTF-8: '+tmp2;
end;

procedure TFrmCharTable.ComboBox1Select(Sender: TObject);
var cnt, x, y :integer;
S,E:Integer;
begin
 S:=UnicodeRanges[Combobox1.ItemIndex].S;
 E:=UnicodeRanges[Combobox1.ItemIndex].E;
 StringGrid1.Clear;
 StringGrid1.ColCount:=16;
 StringGrid1.RowCount:=(E-S) div 15;
 x:=0; y:=0; cnt:=0;
 for y:=0 to StringGrid1.RowCount-1 do
  for x:=0 to StringGrid1.ColCount-1 do
  begin
   if S+Cnt<=E then
   StringGrid1.Cells[x,y]:=UnicodeToUTF8(UnicodeRanges[Combobox1.ItemIndex].S+Cnt);
   inc(cnt);
  end;
end;

procedure TFrmCharTable.ComboBox2Select(Sender: TObject);
begin
  StringGrid1.Font.Name:=ComboBox2.Items[ComboBox2.ItemIndex];
end;


initialization
  {$I woprchartable.lrs}

end.

